/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.supplementaries.client.TextUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class NoticeBoardBlockTileRenderer
implements BlockEntityRenderer<NoticeBoardBlockTile> {
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    private final Font font;
    private final Camera camera;
    private static final float PAPER_X_MARGIN = 0.1875f;
    private static final float PAPER_Y_MARGIN = 0.125f;

    public NoticeBoardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
        this.mapRenderer = minecraft.f_91063_.m_109151_();
        this.font = context.m_173586_();
        this.camera = minecraft.f_91063_.m_109153_();
    }

    public int getFrontLight(Level world, BlockPos pos, Direction dir) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos.m_121945_(dir));
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int overlay) {
        if (!tile.shouldSkipTileRenderer()) {
            BlockPos pos;
            Level level = tile.m_58904_();
            if (level == null) {
                return;
            }
            ItemStack stack = tile.getDisplayedItem();
            if (stack.m_41619_()) {
                return;
            }
            Direction dir = tile.getDirection();
            float yaw = -dir.m_122435_();
            Vec3 cameraPos = this.camera.m_90583_();
            if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)(pos = tile.m_58899_()), (float)yaw, (float)0.0f, (Direction)dir, (float)0.0f)) {
                return;
            }
            int frontLight = this.getFrontLight(level, pos, dir);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(RotHlpr.rot((int)((int)yaw)));
            poseStack.m_85837_(0.0, 0.0, 0.5);
            NoticeBoardBlockTileRenderer.renderNoticeBoardContent(this.mapRenderer, this.font, this.itemRenderer, tile, poseStack, buffer, frontLight, overlay, stack, dir, new LOD(cameraPos, pos));
            poseStack.m_85849_();
        }
    }

    public static void renderNoticeBoardContent(MapRenderer mapRenderer, Font font, ItemRenderer itemRenderer, NoticeBoardBlockTile tile, PoseStack poseStack, MultiBufferSource buffer, int frontLight, int overlay, ItemStack stack, Direction dir, LOD lod) {
        if (tile.isGlowing()) {
            frontLight = 0xF000F0;
        }
        if (stack.m_41720_() instanceof ComplexItem) {
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)tile.m_58904_());
            if (mapData != null) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 0.008);
                poseStack.m_85841_(0.0078125f, -0.0078125f, -0.0078125f);
                poseStack.m_85837_(-64.0, -64.0, 0.0);
                Integer integer = MapItem.m_151131_((ItemStack)stack);
                mapRenderer.m_168771_(poseStack, buffer, integer.intValue(), mapData, true, frontLight);
                poseStack.m_85849_();
            } else {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundRequestMapDataPacket(tile.m_58899_(), player.m_20148_()));
            }
            return;
        }
        String page = tile.getText();
        if (page != null && !page.equals("")) {
            if (!lod.isNearMed()) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.5, 0.008);
            if (MiscUtils.FESTIVITY.isAprilsFool()) {
                float d0 = ColorUtils.getShading((Vector3f)dir.m_253071_());
                TextUtils.renderBeeMovie(poseStack, buffer, frontLight, font, d0);
                poseStack.m_85849_();
                return;
            }
            String bookName = tile.m_8020_(0).m_41786_().getString().toLowerCase(Locale.ROOT);
            if (bookName.equals("credits")) {
                float d0 = ColorUtils.getShading((Vector3f)dir.m_253071_());
                TextUtils.renderCredits(poseStack, buffer, frontLight, font, d0);
                poseStack.m_85849_();
                return;
            }
            TextUtil.RenderProperties textProperties = tile.getTextHolder().computeRenderProperties(frontLight, dir.m_253071_(), () -> ((LOD)lod).isVeryNear());
            if (tile.needsVisualUpdate()) {
                NoticeBoardBlockTileRenderer.updateAndCacheLines(font, tile, page, textProperties);
            }
            List<FormattedCharSequence> rendererLines = tile.getCachedLines();
            float scale = tile.getFontScale();
            poseStack.m_85841_(scale, -scale, scale);
            int numberOfLines = rendererLines.size();
            boolean centered = ClientConfigs.Blocks.NOTICE_BOARD_CENTERED_TEXT.get();
            boolean missingno = bookName.equals("missingno");
            for (int lin = 0; lin < numberOfLines; ++lin) {
                FormattedCharSequence str = rendererLines.get(lin);
                float dx = centered ? (float)(-font.m_92724_(str)) / 2.0f + 0.5f : -0.3125f / scale;
                float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                Matrix4f pose = poseStack.m_85850_().m_252922_();
                if (missingno) {
                    font.m_271703_("\u00a7ka", dx, dy + (float)(8 * lin), textProperties.textColor(), false, pose, buffer, Font.DisplayMode.NORMAL, 0, frontLight);
                    continue;
                }
                if (textProperties.outline()) {
                    font.m_168645_(str, dx, dy + (float)(8 * lin), textProperties.textColor(), textProperties.darkenedColor(), pose, buffer, textProperties.light());
                    continue;
                }
                font.m_272191_(str, dx, dy + (float)(8 * lin), textProperties.darkenedColor(), false, pose, buffer, Font.DisplayMode.NORMAL, 0, textProperties.light());
            }
            poseStack.m_85849_();
            return;
        }
        Material pattern = tile.getCachedPattern();
        if (pattern != null) {
            VertexConsumer builder = pattern.m_119194_(buffer, RenderType::m_110482_);
            int i = tile.getDyeColor().m_41071_();
            float scale = 0.5f;
            int b = (int)(scale * (float)FastColor.ARGB32.m_13669_((int)i));
            int g = (int)(scale * (float)FastColor.ARGB32.m_13667_((int)i));
            int r = (int)(scale * (float)FastColor.ARGB32.m_13665_((int)i));
            int lu = frontLight & 0xFFFF;
            int lv = frontLight >> 16 & 0xFFFF;
            poseStack.m_252880_(0.0f, 0.0f, 0.008f);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.4375f, (float)-0.4375f, (float)0.4375f, (float)0.4375f, (float)0.15625f, (float)0.0625f, (float)0.59375f, (float)0.9375f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
        } else if (!tile.isNormalItem()) {
            BakedModel model = itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
            poseStack.m_85837_(0.0, 0.0, 0.015675);
            poseStack.m_85841_(-0.5f, 0.5f, -0.5f);
            itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, frontLight, overlay, model);
        }
    }

    private static void updateAndCacheLines(Font font, NoticeBoardBlockTile tile, String page, TextUtil.RenderProperties textProperties) {
        float paperWidth = 0.625f;
        float paperHeight = 0.75f;
        FormattedText text = TextUtil.parseText((String)page);
        if (text instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)text;
            text = mc.m_6270_(textProperties.style());
        } else {
            text = Component.m_237113_((String)page).m_6270_(textProperties.style());
        }
        Pair p = TextUtil.fitLinesToBox((Font)font, (FormattedText)text, (float)paperWidth, (float)paperHeight);
        tile.setFontScale(((Float)p.getSecond()).floatValue());
        tile.setCachedPageLines((List)p.getFirst());
    }
}

