/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

class SoftFluidProviderInteraction
implements IFaucetBlockSource,
IFaucetTileSource,
IFaucetTileTarget,
IFaucetBlockTarget {
    SoftFluidProviderInteraction() {
    }

    @Override
    public int getTransferCooldown() {
        return IFaucetBlockSource.super.getTransferCooldown();
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, @Nullable FaucetBlockTile.FillAction fillAction) {
        return SoftFluidProviderInteraction.drainGeneric(level, faucetTank, pos, state, fillAction, state.m_60734_());
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, @Nullable FaucetBlockTile.FillAction fillAction) {
        return SoftFluidProviderInteraction.drainGeneric(level, faucetTank, pos, tile.m_58900_(), fillAction, tile);
    }

    private static InteractionResult drainGeneric(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, @Nullable FaucetBlockTile.FillAction fillAction, Object backBlock) {
        if (backBlock instanceof ISoftFluidProvider) {
            ISoftFluidProvider provider = (ISoftFluidProvider)backBlock;
            SoftFluidStack stack = provider.getProvidedFluid(level, state, pos);
            FaucetBehaviorsManager.prepareToTransferBottle(faucetTank, (Holder<SoftFluid>)stack.getFluid(), stack.getTag());
            if (fillAction == null) {
                return InteractionResult.CONSUME;
            }
            if (fillAction.tryExecute()) {
                provider.consumeProvidedFluid(level, state, pos, faucetTank.getFluid().copyWithCount(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
        return this.tryFillGeneric(level, faucetTank, pos, state, state.m_60734_());
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
        return this.tryFillGeneric(level, faucetTank, pos, tile.m_58900_(), tile);
    }

    public InteractionResult tryFillGeneric(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, Object object) {
        if (object instanceof ISoftFluidConsumer) {
            ISoftFluidConsumer consumer = (ISoftFluidConsumer)object;
            return consumer.tryAcceptingFluid(level, state, pos, faucetTank.getFluid().copyWithCount(1)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

